# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 8
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR8_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Check if opponent's code is trivial (always C or always D)
    if "return \"C\"" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Final round: defect
    if len(my_history) == 9:
        return "D"
    
    # Check if opponent defected in any of the first 3 rounds
    if len(opp_history) >= 3 and any(move == "D" for move in opp_history[:3]):
        return "D"
    
    # Default: cooperate
    return "C"